
package edu.unl.consystlab.sudoku;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;


public class OptimizationMenu extends JMenu implements ActionListener
{
	// optim levels
	public final static int WITHOUT	=0;
	public final static int WITH	=1;
	public final static int WITHXTRA=2;
	public final static int DEFAULT=WITHOUT;
	
	private List puzzles;
	private Game game;
	JRadioButtonMenuItem with, withXtra, without;

	public OptimizationMenu(Game game)
	{
		super("Optimization");
		this.game = game;
		ButtonGroup group = new ButtonGroup();
		with = new JRadioButtonMenuItem("With optimization");
		withXtra = new JRadioButtonMenuItem("With optimization - no animation");
		without = new JRadioButtonMenuItem("Without optimization (brute force)");
		group.add(with);
		group.add(withXtra); 
		group.add(without); 
		without.setSelected(true);
		this.add(with);
		this.add(withXtra);
		this.add(without);
		with.addActionListener(this);
		withXtra.addActionListener(this);
		without.addActionListener(this);
	} // constructor

	public void actionPerformed(ActionEvent event)
	{
		//Debug.debug("OptimizationMenu.actionPerformed()");
		Object o = event.getSource();
		if (o instanceof JRadioButtonMenuItem)
		{
			JRadioButtonMenuItem jr = (JRadioButtonMenuItem)o;
			//Debug.debug("OptimizationMenu.actionPerformed(): radio="+
			//	jr.getActionCommand());
			if(jr==with)
			{
				game.inform("Turn optimization on.");
				game.setOptimization(WITH);
			}
			if(jr==withXtra)
			{
				game.inform("Turn optimization on, animation off.");
				game.setOptimization(WITHXTRA);
			}
			if(jr==without)
			{
				game.inform("Turn optimization off.");
				game.setOptimization(WITHOUT);
			}
		}
	} // actionPerformed();

}
